/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.enchantment.Enchantment;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.EnchantmentPredicate")
@Document(value="vanilla/api/predicate/EnchantmentPredicate")
public final class EnchantmentPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.EnchantmentPredicate> {
    private Enchantment enchantment;
    private IntRangePredicate levels = IntRangePredicate.unbounded();

    public EnchantmentPredicate() {
        super(net.minecraft.advancements.criterion.EnchantmentPredicate.field_192466_a);
    }

    @ZenCodeType.Method
    public EnchantmentPredicate withEnchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
        return this;
    }

    @ZenCodeType.Method
    public EnchantmentPredicate withMinimumLevel(int min) {
        this.levels = IntRangePredicate.mergeLowerBound(this.levels, min);
        return this;
    }

    @ZenCodeType.Method
    public EnchantmentPredicate withMaximumLevel(int max) {
        this.levels = IntRangePredicate.mergeUpperBound(this.levels, max);
        return this;
    }

    @ZenCodeType.Method
    public EnchantmentPredicate withRangedLevel(int min, int max) {
        this.levels = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public EnchantmentPredicate withExactLevel(int value) {
        return this.withRangedLevel(value, value);
    }

    @Override
    public boolean isAny() {
        return this.enchantment == null && this.levels.isAny();
    }

    @Override
    public net.minecraft.advancements.criterion.EnchantmentPredicate toVanilla() {
        if (this.enchantment == null) {
            throw new IllegalStateException("Unable to build an enchantment predicate without an enchantment");
        }
        return new net.minecraft.advancements.criterion.EnchantmentPredicate(this.enchantment, (MinMaxBounds.IntBound)this.levels.toVanillaPredicate());
    }
}

